% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDetectionData.R
\name{loadDetectionData}
\alias{loadDetectionData}
\title{Load Detection Data}
\usage{
loadDetectionData(
  x,
  source = c("makara", "csv"),
  columnMap = NULL,
  detectionType = c("auto", "presence", "detection"),
  presenceDuration = NULL,
  dateFormat = c("\%Y-\%m-\%dT\%H:\%M:\%S+0000", "\%Y-\%m-\%d \%H:\%M:\%S",
    "\%m-\%d-\%Y \%H:\%M:\%S", "\%Y/\%m/\%d \%H:\%M:\%S", "\%m/\%d/\%Y \%H:\%M:\%S"),
  tz = "UTC",
  wide = FALSE,
  speciesCols = NULL,
  detectedValues = NULL,
  extraCols = NULL,
  ...
)
}
\arguments{
\item{x}{dataframe or path to CSV file containing detection data}

\item{source}{source of the detection data, choices other than "csv"
just specify specific formatting options}

\item{columnMap}{a list or data.frame specifying how to map the input
column names to the required standard names of "UTC", "end", and "species".
If a list, must be a named list where the names are the standardized
column names and the values are the existing names, e.g.
\code{list('UTC'='start', 'species'='SpeciesName')}. If a data.frame,
must have columns "old" with the existing column names and "new" with
the standardized name to change it to. All columns successfully changed
will be kept with the output}

\item{detectionType}{one of "auto", "presence", or "detection" specifying
the type of detection in the data. "presence" means hourly or daily presence
style of detections - the duration of the detection is used for the time
unit (e.g. hourly presence might have "UTC" value 2020-01-01 12:00:00 and
"end" value 2020-01-01 13:00:00 for a detection). "detection" means the data
refer to specific detections or bouts of detections rather than just presence.
"auto" means that the type of detection will be inferred from the start and
end time of each detection - any detections with a duration of exactly one
hour or exactly one day will be marked as "presence", any other duration
will be marked as "detection"}

\item{presenceDuration}{if \code{detectionType='presence'}, the duration in
seconds, e.g. 86400 for daily presence. Alternative can be a character
of the form "(NUMBER)(DURATION)" e.g "2hour" or "1day"}

\item{dateFormat}{format string of dates, see \link{strptime}. Can be a
vector of multiple formats}

\item{tz}{time zone of input data}

\item{wide}{logical flag indicating whether the input data has species
detection information in wide (instead of long) format. If \code{TRUE},
then this means that there are multiple columns representing multiple
kinds of detections, e.g. one column for each different species present.
If \code{FALSE}, then there is a single column that indicates what kind
of detection it is.}

\item{speciesCols}{only used if \code{wide=TRUE}, the names of the columns
containing the different types of detections}

\item{detectedValues}{only used if \code{wide=TRUE}, the values in each
\code{speciesCols} column that indicate a positive detection. e.g. if
"0" represents no detection and "1" represents a detection, then this
should be "1". Note that all values will be converted to characters,
so the string \code{"1"} must be used instead of the numeric \code{1}}

\item{extraCols}{(optional) any additional columns to keep with the output}

\item{\dots}{additional arguments used for certain \code{source} values}
}
\value{
a dataframe with columns UTC, end, species, and detectionType, where
each row represents a single detection event. May have additional columns
depending on other parameters
}
\description{
Loads and formats detection data into a common format for
use in other PAMscapes functions
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
