% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSoundscapeInput.R
\name{checkSoundscapeInput}
\alias{checkSoundscapeInput}
\title{Check Proper Formatting for Soundscape Inputs}
\usage{
checkSoundscapeInput(x, needCols = c("UTC"))
}
\arguments{
\item{x}{a dataframe, path to a CSV file, or path to a MANTA
NetCDF file}

\item{needCols}{names of columns that must be present in \code{x},
if any are missing will trigger an error}
}
\value{
a dataframe
}
\description{
Reads and checks data to ensure formatting will work
for other \code{PAMscapes} functions. Will read and check the
formatting of CSV files, or check the formatting of dataframes.
Can also read in MANTA NetCDF files and format the data
appropriately.
}
\details{
Files created by MANTA and Triton software will be
reformatted to have consisitent formatting. The first column
will be renamed to "UTC", and columns containing soundscape
metrics will be named using the convention "TYPE_FREQUENCY",
e.g. "HMD_1", "HMD_2" for Manta hybrid millidecade mesaurements.

Inputs from sources other than MANTA or Triton can be accepted
in either "wide" or "long" format. Wide format must follow
the conventions above - first column "UTC", other columns
named by "TYPE_FREQUENCY" where TYPE is consistent across all
columns and FREQUENCY is in Hertz. Long format data must have
the following columns:
\itemize{
\item{"UTC"}{ - time of the measurement, in UTC timezone}
\item{"type"}{ - the type of soundscape measurement e.g.
PSD or OL, must be the same for all}
\item{"frequency"}{ - the frequency of the measurement, in Hertz}
\item{"value"}{ - the soundscape measurement value, usually dB}
}
}
\examples{

manta <- checkSoundscapeInput(system.file('extdata/MANTAExampleSmall1.csv', package='PAMscapes'))
str(manta)
ol <- checkSoundscapeInput(system.file('extdata/OLSmall.csv', package='PAMscapes'))
str(ol)
psd <- checkSoundscapeInput(system.file('extdata/PSDSmall.csv', package='PAMscapes'))
str(psd)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
