% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAcousticScene.R
\name{plotAcousticScene}
\alias{plotAcousticScene}
\title{Plot Acoustic Scene}
\usage{
plotAcousticScene(
  x,
  freqMap,
  typeCol = "species",
  title = NULL,
  bin = "1day",
  scale = c("log", "linear"),
  freqMin = NULL,
  freqMax = NULL,
  alpha = 1
)
}
\arguments{
\item{x}{dataframe of detections, must have column \code{UTC} and
a column to connect detection types to the frequency type map}

\item{freqMap}{a dataframe listing frequency ranges to use for
various detection types in \code{x}. Must have columns \code{type},
\code{freqMin} (Hz), \code{freqMax} (Hz), and optionally \code{color}
(color to use for this type of detection on plot)}

\item{typeCol}{column name in \code{x} that matches names in \code{type}
column in \code{freqMap}}

\item{title}{optional title to use for the plot}

\item{bin}{time bin to use for plotting time axis. Each detection will
be displayed as covering this amount of time}

\item{scale}{one of \code{log} or \code{linear}, the frequency scale for
the plot}

\item{freqMin}{optional minimum frequency for plot, useful for log scale}

\item{freqMax}{optional maximum frequency for plot}

\item{alpha}{transparency percentage for plotting, values less than 1
will allow multiple overlapping colors to be seen}
}
\value{
a ggplot object
}
\description{
Plots a representation of the acoustic scene using
detections in data. Frequency ranges for detections are taken
from user input and displayed as different colored bars
}
\examples{
detDf <- data.frame(
   UTC=as.POSIXct(c('2023-01-01 00:00:00',
                    '2023-01-03 00:00:00',
                    '2023-01-02 12:00:00',
                    '2023-01-04 00:00:00'),
                  tz='UTC'),
  species = c('Dolphin', 'Whale', 'Whale', 'Dolphin'))
freqMap <- data.frame(type=c('Dolphin', 'Whale'),
                      freqMin=c(10e3, 100),
                      freqMax=c(30e3, 400),
                      color=c('darkgreen', 'blue'))
plotAcousticScene(detDf, freqMap=freqMap, typeCol='species', bin='1day')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
