\name{PATHChange}
\alias{PATHChange}
\title{Determination of differentially expressed pathways using multi-statistic comparison}
\description{This is the main function of the PATHChange package. It applies to each histological comparison selected that the three non-parametric tests (Bootstrap, Fisher's exact and Wilcoxon signed-rank).}
\usage{
PATHChange(path, MeanData, writeCSV, writeRDS, destDIR)
}
\arguments{
  \item{path}{List of pathways previously generated by the function PATHChangeList.}
  \item{MeanData}{List of the results of the histological comparisons chosen by the user (It can be calculated by the function PATHChangeDat).}
  \item{writeCSV}{TRUE for write a .csv file result}
  \item{writeRDS}{TRUE for write a .rds file result}
  \item{destDIR}{Destination folder for .csv and .rds files.}
}
\details{The approach is a multiple comparison experiment since it involves several pathways, then PATHChange corrects the false discovery rate (FDR) based on Benjamini-Hochberg algorithm.}
\value{
\item{p.value}{Results}}
\author{Carla A. R. S. Fontoura}
\seealso{\code{\link{PATHChangeList}}, \code{\link{PATHChangeDat}}}
\examples{
require(rlist)
path<-list.load(system.file("extdata", "path.rds", package = "PATHChange"))[c(1:10)]
MeanData<-list.load(system.file("extdata", "MeanData.rds", package = "PATHChange"))
  
\dontrun{PATHChange(path=path, MeanData=MeanData, writeCSV=FALSE, writeRDS=FALSE)}
\dontrun{p.value <- list.load(file.path(tempdir(),"pValue.rds"))}
}