% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sed_summary.R
\name{sed_summary}
\alias{sed_summary}
\title{Physical Activity Summary--Sedentary Proportions and Percentiles}
\usage{
sed_summary(final_dat)
}
\arguments{
\item{final_dat}{cleaned final data that is between record getup time and sleep time}
}
\value{
\code{total_sed_time} Total sedantary hour, same as PA_summary function output sed_hour

\code{total_number_of_sed_bouts} Total number of sedentary bouts_ It counts the number of sedentary recordings_

\code{mean_sed_bout_length} Mean sedentary bout length_ It is the average of the duration time for all sedentary activities

\code{prop_of_sed_time_greater_20min} Proportions of sedentary bout greater than 20 minutes

\code{prop_of_sed_time_greater_60min} Proportions of sedentary bout greater than 60 minutes

\code{prop_of_sed_time_greater_120min} Proportions of sedentary bout greater than 120 minutes

\code{total_sed_time_greater_20min} Total sedentary time greater than 20 minutes

\code{total_sed_time_greater_60min} Total sedentary time greater than 60 minutes

\code{total_sed_time_greater_120min} Total sedentary time greater than 120 minutes

\code{percentile_sed_time_5}  5\% Percentile of sedentary time

\code{percentile_sed_time_25} 25\% Percentile of sedentary time

\code{percentile_sed_time_50} 50\% Percentile of sedentary time

\code{percentile_sed_time_75} 75\% Percentile of sedentary time

\code{percentile_sed_time_95} 95\% Percentile of sedentary time

\code{alpha_sed} alpha of sendataty time, see details_

\code{prop_sed_time_6_12} Proportions of sedentary time between 6:00-12:00

\code{prop_sed_time_12_18} Proportions of sedentary time between 12:00-18:00

\code{prop_sed_time_18_22} Proportions of sedentary time between 18:00-22:00
}
\description{
Summarize activity measures using proportions and percentiles
}
\details{
Proportions of sedentary bout greater than 20/60/120 minutes is the ratio of the number of sedentary bouts greater than 20/60/120 minutes to the total number of sedentary recordings_

Total sedentary time greater than 20/60/120 minutes is the summation of the sedentary durations which are greater than 20/60/120 minutes_

To calculate 5\%/25\%/___/95\% percentile of sedentary time, all of the recorded sedentary durations are listed and R function \emph{quantile} is used to find the percentiles_

alpha_sed is defined by \code{1+1/M}, where \code{M} is the average of \code{log(sedentary bout length /minimum sedentary bout length)}_

Proportions of sedentary time between 6:00-12:00/12:00-18:00/18:00-22:00 is the ratio of the sedentary durations to the total activity durations between 6:00-12:00/12:00-18:00/18:00-22:00_
}
\examples{
 data(sampledata);sed_summary(sampledata)
}

