% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_paired_equivalence.R,
%   R/plot_shaded_unshaded.R
\name{plot.paired_equivalence}
\alias{plot.paired_equivalence}
\alias{shaded_equivalence_plot}
\alias{unshaded_equivalence_plot}
\title{Plot the outcome of a paired equivalence test}
\usage{
\method{plot}{paired_equivalence}(x, shade = "auto", ...)

shaded_equivalence_plot(results, ...)

unshaded_equivalence_plot(results, ...)
}
\arguments{
\item{x}{the object to be plotted}

\item{shade}{logical. Should the results be plotted using a shaded
equivalence region?}

\item{...}{arguments passed to \code{ggplot2::theme}.}

\item{results}{data frame. The \code{results} component of a
\code{paired_equivalence} object}
}
\value{
A plot of the equivalence test
}
\description{
Plot the outcome of a paired equivalence test
}
\details{
\code{shaded_equivalence_plot} plots the results of an equivalence test in
which a single equivalence region applies to all variables. In that case, the
equivalence region is displayed as a shaded region.
\code{unshaded_equivalence_plot} plots the results of an equivalence test in
which variables have unique equivalence regions. In that case, the
equivalence regions are displayed as dodged "confidence intervals".
}
\examples{
set.seed(1544)
y <- rnorm(500, 17.4, 9)
z <- data.frame(
  var1 = rnorm(500, 15, 4),
  var2 = rnorm(500, 23, 7.3)
)

# Optionally create artificial missing values to trigger unshaded plot
missing_indices <- sample(seq(nrow(z)), 250)
z$var1[missing_indices] <- NA

x <- paired_equivalence_test(
  z, y, "criterion", scale = "relative",
  relative_region_width = 0.25
)

plot(x)
}
