% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMVar}
\alias{PCMVar}
\title{Expected variance-covariance matrix for each couple of tips (i,j)}
\usage{
PCMVar(tree, model, W0 = matrix(0, PCMNumTraits(model),
  PCMNumTraits(model)), SE = matrix(0, PCMNumTraits(model),
  PCMTreeNumTips(tree)), metaI = PCMInfo(NULL, tree, model, verbose =
  verbose), internal = FALSE, verbose = FALSE)
}
\arguments{
\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{W0}{a numeric matrix denoting the initial k x k variance covariance matrix at the
root (default is the k x k zero matrix).}

\item{SE}{a k x N matrix specifying the standard error for each measurement in
X. Alternatively, a k x k x N cube specifying an upper triangular k x k
factor of the variance covariance matrix for the measurement error
for each node i=1, ..., N.
Default: \code{matrix(0.0, PCMNumTraits(model), PCMTreeNumTips(tree))}.}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model, SE)},
containing meta-data such as N, M and k. Alternatively, this can be a
function object that returns such a list, e.g. the function\code{PCMInfo}
or the function \code{PCMInfoCpp} from the \code{PCMBaseCpp} package.}

\item{internal}{a logical indicating if the per-node variance-covariances matrices for
the internal nodes should be returned (see Value). Default FALSE.}

\item{verbose}{logical indicating if some debug-messages should printed.}
}
\value{
If internal is FALSE, a (k x N) x (k x N) matrix W, such that k x k block
\code{W[((i-1)*k)+(1:k), ((j-1)*k)+(1:k)]} equals the expected
covariance matrix between tips i and j. Otherwise, a list with an element 'W' as described above and
a k x M matrix element 'Wii' containing the per-node variance covariance matrix for each node:
The k x k block \code{Wii[, (i-1)*k + (1:k)]} represents the variance covariance matrix for node i.
}
\description{
Expected variance-covariance matrix for each couple of tips (i,j)
}
\examples{
# a Brownian motion model with one regime
modelBM <- PCM(model = "BM", k = 2)
# print the model
modelBM
# assign the model parameters at random: this will use uniform distribution
# with boundaries specified by PCMParamLowerLimit and PCMParamUpperLimit
# We do this in two steps:
# 1. First we generate a random vector. Note the length of the vector equals PCMParamCount(modelBM)
randomParams <- PCMParamRandomVecParams(modelBM, PCMNumTraits(modelBM), PCMNumRegimes(modelBM))
randomParams
# 2. Then we load this random vector into the model.
PCMParamLoadOrStore(modelBM, randomParams, 0, PCMNumTraits(modelBM), PCMNumRegimes(modelBM), TRUE)

# create a random tree of 10 tips
tree <- ape::rtree(10)
covMat <- PCMVar(tree, modelBM)
}
