% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMParam.R
\name{PCMParamGetShortVector}
\alias{PCMParamGetShortVector}
\title{Get a vector of the variable numeric parameters in a model}
\usage{
PCMParamGetShortVector(o, k = 1L, R = 1L, ...)
}
\arguments{
\item{o}{a PCM model object or a parameter of a PCM object}

\item{k}{an integer denoting the number of modeled traits. Default: 1.}

\item{R}{an integer denoting the number of regimes in the model. Default: 1.}

\item{...}{other arguments that could be used by implementing methods.}
}
\value{
a numeric vector of length equal to `PCMParamCount(o, FALSE, FALSE, 0L, k, R)`.
}
\description{
The short vector of the model parameters does not include the
nodes in the tree where a regime change occurs, nor the the model types associated
with each regime.
}
