% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeListDescendants}
\alias{PCMTreeListDescendants}
\title{A list of the descendants for each node in a tree}
\usage{
PCMTreeListDescendants(tree,
  tableAncestors = PCMTreeTableAncestors(tree))
}
\arguments{
\item{tree}{a phylo object}

\item{tableAncestors}{an integer matrix resulting from a call to
PCMTreeTableAncestors(tree).}
}
\value{
a list with unnamed elements in the order of nodes in the tree. Each
element is an integer vector containing the descendant nodes (in increasing
 order) of the node identified by its index-number in the list.
}
\description{
A list of the descendants for each node in a tree
}
\details{
This function has time and memory complexity O(M^2), where M is the
 number of nodes in the tree. It can take several minutes and gigabytes of
 memory on trees of more than 10000 tips.
}
