% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergeKW.R
\name{MergeKW}
\alias{MergeKW}
\alias{MergePrefix}
\alias{MergeSuffix}
\title{Merge keyword strings}
\usage{
MergeKW(x, y, delim = c("space", "dash", "period"))

MergePrefix(x, y, delim = c("space", "dash", "period"))

MergeSuffix(x, y, delim = c("space", "dash", "period"))
}
\arguments{
\item{x}{A character vector. If not, coerced to character by 
\code{as.character}.}

\item{y}{A list of character vectors with pairs of strings that are to be 
merged (for \code{MergeKW}) or a character vector of strings which are to 
be merged to succeeding string (for \code{MergePrefix}) or the preceding 
string (for \code{MergeSuffix}). If not of type character, coerced by 
\code{as.character}.}

\item{delim}{Delimiting characters to be removed between keywords.}
}
\value{
A character vector of the same length as \code{x} with the required 
  keyword strings merged.
}
\description{
These functions merge keyword strings separated by delimiters such as space, 
period or dash in a character vector into single keyword strings.
}
\details{
These functions aid in standardization of relevant data fields(columns) in 
PGR passport data for creation of a KWIC index with 
\code{\link[PGRdup]{KWIC}} function and subsequent identification of probable
duplicate accessions by the \code{\link[PGRdup]{ProbDup}} function.

It is recommended to run this function before using the 
\code{\link[PGRdup]{DataClean}} function on the relevant data fields(columns)
of PGR passport databases.

\code{MergeKW} merges together pairs of strings specified as a list in 
argument \code{y} wherever they exist in a character vector. The second 
string in the pair is merged even when it is followed by a number.

\code{MergePrefix} merges prefix strings specified as a character vector in 
argument \code{y} to the succeeding root word, wherever they exist in a 
character vector.

\code{MergeSuffix} merges suffix strings specified as a character vector in 
argument \code{y} to the preceding root word, wherever they exist in a 
character vector. The suffix strings which are followed by numbers are also 
merged.
}
\examples{
names <- c("Punjab Bold", "Gujarat- Dwarf", "Nagpur.local", "SAM COL 144",
           "SAM COL--280", "NIZAMABAD-LOCAL", "Dark Green Mutant",
           "Dixie-Giant", "Georgia- Bunch", "Uganda-erect", "Small Japan",
           "Castle  Cary", "Punjab erect", "Improved small japan",
           "Dark Purple")

# Merge pairs of strings
y1 <- list(c("Gujarat", "Dwarf"), c("Castle", "Cary"), c("Small", "Japan"),
           c("Big", "Japan"), c("Mani", "Blanco"), c("Uganda", "Erect"),
           c("Mota", "Company"))
names <- MergeKW(names, y1, delim = c("space", "dash", "period"))

# Merge prefix strings
y2 <- c("Light", "Small", "Improved", "Punjab", "SAM")
names <- MergePrefix(names, y2, delim = c("space", "dash", "period"))

# Merge suffix strings
y3 <- c("Local", "Bold", "Cary", "Mutant", "Runner", "Giant", "No.",
        "Bunch", "Peanut")
names <- MergeSuffix(names, y3, delim = c("space", "dash", "period"))
}
\seealso{
\code{\link[PGRdup]{DataClean}}, \code{\link[PGRdup]{KWIC}}, 
  \code{\link[PGRdup]{ProbDup}}
}

