% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceLR.R
\name{reduceLR}
\alias{reduceLR}
\title{Reduce a logistic regression with monotone likelihood to a conditional regression with
double descending likelihood.}
\usage{
reduceLR(Z, nvec = NULL, yvec = NULL, keep, sst = NULL)
}
\arguments{
\item{Z}{regression matrix}

\item{nvec}{vector of sample sizes}

\item{yvec}{vector of responses}

\item{keep}{vector of variable names to block from consideration for removal.}

\item{sst}{vector of sufficient statistics}
}
\value{
a list with components
\itemize{
  \item keepme indicators of which variables are retained in the reduced data set
  \item moderate indicatiors of which observations are retained in the reduced data set
  \item extreme indicators of which observations are removed in the reduced data set
  \item toosmall indicator of whether resulting data set is too small to fit the proportional hazards regression
}
}
\description{
Reduce a logistic regression with monotone likelihood to a conditional regression with
double descending likelihood.
}
\details{
This function implements version of \insertCite{kolassa97;textual}{PHInfiniteEstimates}.  
It is intended for use with extensions to multinomial regression as in \insertCite{kolassa97;textual}{PHInfiniteEstimates} and to survival analysis as in \insertCite{kz19;textual}{PHInfiniteEstimates}.
The method involves linear optimization that is potentially repeated.  Initial calculations were done using a proprietary coding of the simplex, in a way that allowed for later iterations to be restarted from earlier iterations; this computational advantage is not employed here, in favor of computational tools in the public domain and included in the R package lpSolve.  
Furthermore, \insertCite{kolassa97;textual}{PHInfiniteEstimates} removed regressors that became linearly dependent using orthogonalization, but on further reflection this computation is unnecessary.
Data in the examples are from \insertCite{mehtapatel;textual}{PHInfiniteEstimates}, 
citing \insertCite{goorinetal87;textual}{PHInfiniteEstimates}.
}
\examples{
#Cancer Data
Z<-cbind(rep(1,8),c(rep(0,4),rep(1,4)),rep(c(0,0,1,1),2),rep(c(0,1),4))
dimnames(Z)<-list(NULL,c("1","LI","SEX","AOP"))
nvec<-c(3,2,4,1,5,5,9,17); yvec<-c(3,2,4,1,5,3,5,6)
reduceLR(Z,nvec,yvec,c("SEX","AOP"))
#CD4, CD8 data
Z<-cbind(1,c(0,0,1,1,0,0,1,0),c(0,0,0,0,1,1,0,1),c(0,0,0,0,0,1,1,0),c(0,1,0,1,0,0,0,1))
dimnames(Z)<-list(NULL,c("1","CD41","CD42","CD81","CD82"))
nvec<-c(7,1,7,2,2,13,12,3); yvec<-c(4,1,2,2,0,0,4,1)
reduceLR(Z,nvec,yvec,"CD41")
}
\references{
\insertRef{mehtapatel}{PHInfiniteEstimates}

\insertRef{goorinetal87}{PHInfiniteEstimates}

\insertRef{kolassa97}{PHInfiniteEstimates}

\insertRef{kolassa16}{PHInfiniteEstimates}

\insertRef{kz19}{PHInfiniteEstimates}
}
