% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/char_to_numeric.R
\name{char_to_numeric}
\alias{char_to_numeric}
\title{convert all columns to numeric}
\usage{
char_to_numeric(df, exclude_cols = "C")
}
\arguments{
\item{df}{dataframe to convert character columns to numeric}

\item{exclude_cols}{vector of column names to be skipped from conversion}
}
\value{
dataframe
}
\description{
defaults to convert all character columns except named 'C' to numeric
useful for nonmem ready datasets with `.` for missing values
}
\examples{
\dontrun{
nm_dat <- char_to_numeric(nm_dat)
   # if 'C' col is 0/1 rather than typical 'C' or '.'
nm_dat <- char_to_numeric(nm_dat, exclude_cols = NULL) 
}
}
