# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' calculate partial AUC
#' @param time vector of time values
#' @param dv concentration measurements
#' @param range vector of min and max value of the partial auc range
#' @examples \dontrun{
#' library(dplyr)
#' sd_oral_richpk %>% group_by(ID) %>% 
#'   summarize(pauc0_12 = auc_partial_cpp(Time, Conc, c(0, 12)))
#' }
auc_partial_cpp <- function(time, dv, range) {
    .Call('_PKPDmisc_auc_partial_cpp', PACKAGE = 'PKPDmisc', time, dv, range)
}

clean_nonmem <- function(x, sep, colname) {
    .Call('_PKPDmisc_clean_nonmem', PACKAGE = 'PKPDmisc', x, sep, colname)
}

clean_phi <- function(x, sep, colname) {
    .Call('_PKPDmisc_clean_phi', PACKAGE = 'PKPDmisc', x, sep, colname)
}

#' given NA values fill them with the next non-na value
#' @param x A numeric vector of values
#' @details
#' Works very well in context of dplyr to carry out backwards imputation
#' @examples 
#' fill_backward(c(1.0, NA, 2))
#' fill_backward(c(NA, 1, NA, 2))
#' library(dplyr)
#' df <- data_frame(id = c(1, 1, 2, 2), obs = c(1.2, 4.8, 2.5, NA))
#' df %>% group_by(id) %>% mutate(obs_imp = fill_backward(obs))
#' @export
fill_backward <- function(x) {
    .Call('_PKPDmisc_fill_backward', PACKAGE = 'PKPDmisc', x)
}

#' given NA values fill them with the final non-na value
#' @param x A numeric vector of values
#' @details
#' Works very well in context of dplyr to carry out last-observation-carried-foward
#' for different individuals. It will NOT replace leading NA's
#' @examples 
#' fill_forward(c(1.0, NA, 2))
#' fill_forward(c(NA, 1, NA, 2))
#' library(dplyr)
#' df <- data_frame(id = c(1, 1, 2, 2), obs = c(1.2, 4.8, 2.5, NA))
#' df %>% group_by(id) %>% mutate(obs_locf = fill_forward(obs))
#' @export
fill_forward <- function(x) {
    .Call('_PKPDmisc_fill_forward', PACKAGE = 'PKPDmisc', x)
}

#' give the min value up to that point
#' @param x A numeric vector of values
#' @details
#' useful for safety analyses where an event may be defined as a certain change
#' in a biomarker, so need to see how the current measurement compares to the minimum
#' value up to that point
#' @examples 
#'min_through(c(4, 3, 3, 2, 4, 1))
#'min_through(c(NA, 2))
#' @export
min_through <- function(x) {
    .Call('_PKPDmisc_min_through', PACKAGE = 'PKPDmisc', x)
}

#' give the max value up to that point
#' @param x A numeric vector of values
#' @details
#' useful for safety analyses where an event may be defined as a certain change
#' in a biomarker, so need to see how the current measurement compares to the maximum
#' value up to that point
#' @examples 
#'max_through(c(4, 3, 3, 2, 5, 1))
#'max_through(c(NA, 2, 1, 4, 2))
#' @export
max_through <- function(x) {
    .Call('_PKPDmisc_max_through', PACKAGE = 'PKPDmisc', x)
}

padLeft <- function(strings, numChars, paddingChar) {
    .Call('_PKPDmisc_padLeft', PACKAGE = 'PKPDmisc', strings, numChars, paddingChar)
}

replace_chars <- function(strings, values, replacement) {
    .Call('_PKPDmisc_replace_chars', PACKAGE = 'PKPDmisc', strings, values, replacement)
}

replace_spaces <- function(x) {
    .Call('_PKPDmisc_replace_spaces', PACKAGE = 'PKPDmisc', x)
}

#' given a set of bin ranges, assign each value to a bin
#' @details
#' Given a set of quantiles/bins/etc established from a separate dataset, it can 
#' be useful to assign the same bins to new or simulated data for comparisons
#' or to do additional analysis such as assign dropouts etc. This function can be
#' used to take the breakpoints to establish bins quickly and easily
#' @param x A numeric vector of values
#' @param left,right Boundary values
#' @export
set_bins_cpp <- function(x, left, right) {
    .Call('_PKPDmisc_set_bins_cpp', PACKAGE = 'PKPDmisc', x, left, right)
}

