% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLN.R
\name{PLN}
\alias{PLN}
\title{Poisson lognormal model}
\usage{
PLN(formula, data, subset, weights, control = PLN_param())
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which PLN is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{an optional vector of observation weights to be used in the fitting process.}

\item{control}{a list-like structure for controlling the optimization, with default generated by \code{\link[=PLN_param]{PLN_param()}}. See the associated documentation
for details.}
}
\value{
an R6 object with class \code{\link{PLNfit}}
}
\description{
Fit the multivariate Poisson lognormal model with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets, weights).
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1, data = trichoptera)
}
\seealso{
The class \code{\link{PLNfit}} and the configuration function \code{\link[=PLN_param]{PLN_param()}}
}
