% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPLNfit-S3methods.R
\name{coef.ZIPLNfit}
\alias{coef.ZIPLNfit}
\title{Extract model coefficients}
\usage{
\method{coef}{ZIPLNfit}(object, type = c("count", "zero", "precision", "covariance"), ...)
}
\arguments{
\item{object}{an R6 object with class \code{\link{ZIPLNfit}}}

\item{type}{type of parameter that should be extracted. Either "count" (default) for \eqn{B},
"zero" for \eqn{B0}, "precision" for \eqn{\Omega}, "covariance" for \eqn{\Sigma}}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
A matrix of coefficients extracted from the ZIPLNfit model.
}
\description{
Extracts model coefficients from objects returned by \code{\link[=ZIPLN]{ZIPLN()}} and its variants
}
\examples{
data(scRNA)
# data subsample: only 100 random cell and the 50 most varying transcript
subset <- sample.int(nrow(scRNA), 100)
myPLN  <- ZIPLN(counts[, 1:50] ~ 1 + offset(log(total_counts)), subset = subset, data = scRNA)

}
\seealso{
\code{\link[=sigma.ZIPLNfit]{sigma.ZIPLNfit()}}
}
