% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrtTest.R
\name{osrtTest}
\alias{osrtTest}
\alias{osrtTest.default}
\alias{osrtTest.formula}
\alias{osrtTest.aov}
\title{One-Sided Studentized Range Test}
\usage{
osrtTest(x, ...)

\method{osrtTest}{default}(x, g, alternative = c("greater", "less"), ...)

\method{osrtTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  ...
)

\method{osrtTest}{aov}(x, alternative = c("greater", "less"), ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{greater}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"osrt"} that contains the following components:

\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated statistic(s)}
 \item{crit.value}{critical values for \eqn{\alpha = 0.05}.}
 \item{alternative}{a character string describing the alternative hypothesis.}
 \item{parameter}{the parameter(s) of the test distribution.}
\item{dist}{a string that denotes the test distribution.}
}
There are print and summary methods available.
}
\description{
Performs Hayter's one-sided studentized range
test against an ordered alternative for normal data
with equal variances.
}
\details{
Hayter's one-sided studentized range test (OSRT) can be used
for testing several treatment levels with a zero control in a balanced
one-factorial design with normally distributed variables that have a
common variance. The null hypothesis, H: \eqn{\mu_i = \mu_j ~~ (i < j)}
is tested against a simple order alternative,
A: \eqn{\mu_i < \mu_j}, with at least one inequality being strict.

The test statistic is calculated as,
\deqn{
 \hat{h} = \max_{1 \le i < j \le k} \frac{ \left(\bar{x}_j - \bar{x}_i \right)}
 {s_{\mathrm{in}} / \sqrt{n}},
}{%
SEE PDF.
}

with \eqn{k} the number of groups, \eqn{n = n_1, n_2, \ldots, n_k} and
\eqn{s_{\mathrm{in}}^2} the within ANOVA variance. The null hypothesis
is rejected, if \eqn{\hat{h} > h_{k,\alpha,v}}, with \eqn{v = N - k}
degree of freedom.

For the unbalanced case with moderate imbalance the test statistic is
\deqn{
 \hat{h} = \max_{1 \le i < j \le k} \frac{ \left(\bar{x}_j - \bar{x}_i \right)}
 {s_{\mathrm{in}} \sqrt{1/n_j + 1/n_i}},
}{%
SEE PDF.
}

The function does not return p-values. Instead the critical h-values
as given in the tables of Hayter (1990) for \eqn{\alpha = 0.05} (one-sided)
are looked up according to the number of groups (\eqn{k}) and
the degree of freedoms (\eqn{v}).
Non tabulated values are linearly interpolated with the function
\code{\link[stats]{approx}}.
}
\note{
Hayter (1990) has tabulated critical h-values for balanced designs only.
For some unbalanced designs some \eqn{k = 3} critical h-values
can be found in Hayter et al. 2001. ' The function will give
a warning for the unbalanced case and returns the
critical value \eqn{h_{k,\alpha,v} / \sqrt{2}}.
}
\examples{
##
md <- aov(weight ~ group, PlantGrowth)
anova(md)
osrtTest(md)
MTest(md)
}
\references{
Hayter, A. J.(1990) A One-Sided Studentised Range
Test for Testing Against a Simple Ordered Alternative,
\emph{Journal of the American Statistical Association}
\bold{85}, 778--785.

Hayter, A.J., Miwa, T., Liu, W. (2001)
Efficient Directional Inference Methodologies for the
Comparisons of Three Ordered Treatment Effects.
\emph{J Japan Statist Soc} \bold{31}, 153–174.
}
\seealso{
\code{link{hayterStoneTest}} \code{\link{MTest}}
}
\concept{parametric}
\keyword{htest}
