% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnadc_labeller.R
\name{pnadc_labeller}
\alias{pnadc_labeller}
\title{Label categorical variables from PNADC datasets}
\usage{
pnadc_labeller(data_pnadc, dictionary.file)
}
\arguments{
\item{data_pnadc}{A tibble of PNADc data read with \code{read_pnadc} function.}

\item{dictionary.file}{The dictionary file for selected survey available on official website: \url{ftp://ftp.ibge.gov.br/Trabalho_e_Rendimento/Pesquisa_Nacional_por_Amostra_de_Domicilios_continua/Trimestral/Microdados/Documentacao/Dicionario_e_input.zip}}
}
\value{
A tibble with the data provided from PNADc survey and its categorical variables as factors with labels.
}
\description{
Label categorical variables from PNADC datasets
}
\examples{
input_path <- pnadc_example("input_example.txt")
data_path <- pnadc_example("exampledata.txt")
dictionary.path <- pnadc_example("dictionaryexample.xls")
pnadc.df <- read_pnadc(data_path, input_path, vars="VD4002")
pnadc.df <- pnadc_labeller(pnadc.df,dictionary.path)

}
