% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSTmData.R
\name{POSTmData}
\alias{POSTmData}
\alias{metadata}
\alias{otu}
\alias{otutree}
\alias{otuseq}
\title{Example Dataset For Illustration}
\format{
POSTmData contains 4 objects.
 \describe{
  \item{metadata}{a data.frame containing 30 participants. The
  data.frame contains 3 columns} 
  \describe{
  \item{SampleID}{Character. Unique participant identifiers.}
  \item{mRace}{A dichotomous covariate describing the maternity race.}
  \item{GC}{Gestational complication indicator. "BV" indicates that
            individual was diagnosed with bacterial vaginosis; "Normal"
            otherwise}
  }
  \item{otu}{a 39 x 189 matrix containing OTU count data}
  \item{otutree}{a phylogenetic tree constructed using all 2711 OTU sequences}
  \item{otuseq}{a character vector of OTU sequencing data used to construct 
                the phylogenetic tree}
  }
}
\usage{
data(POSTmData)
}
\description{
This data set is provided for the purposes of illustrating the use of
the software. It was adapted from the vaginal microbiome dataset from 
Subramaniam et al. (2016). The original dataset consists of 39 
individuals with 19 bacterial vaginosis (BV) patients and 20 healthy controls.
The sequencing data and metadata are publicly available at NCBI SRA database
(PRJNA600021). Initial data processing, lead to 2711 OTUs formed at 97\%
sequence similarity. FastTree (Price et al, 2010) was used to construct the 
phylogenetic tree. The OTUs data have been filitered to exclude those with 
abundance < 0.005\% and prevalence < 10\%.
}
\keyword{datasets}
