% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryPOUMM.R
\name{plot.summary.POUMM}
\alias{plot.summary.POUMM}
\title{Plot a summary of a POUMM fit}
\usage{
\method{plot}{summary.POUMM}(x, type = c("MCMC"), doPlot = TRUE,
  stat = c("alpha", "theta", "sigma", "sigmae", "g0", "H2tMean"),
  chain = NULL, doZoomIn = FALSE,
  zoomInFilter = paste0("(stat \%in\% c('H2e','H2tMean','H2tInf','H2tMax') & ",
  "(value >= 0 & value <= 1) ) |",
  "( !stat \%in\% c('H2e','H2tMean','H2tInf','H2tMax') & ",
  "(value <= median(HPDUpper) + 4 * (median(HPDUpper) - median(HPDLower)) &",
  "value >= median(HPDLower) - 4 * (median(HPDUpper) - median(HPDLower))))"),
  palette = c("#999999", "#0072B2", "#CC79A7", "#E69F00", "#D55E00",
  "#56B4E9", "#009E73", "#F0E442"), prettyNames = TRUE,
  showUnivarDensityOnDiag = FALSE, ...)
}
\arguments{
\item{x}{An object of class POUMM.}

\item{type}{A character indicating the type of plot(s) to be generated.
Defaults to "MCMC", resulting in a trace and density plot for the selected
statistics (see argument stat). Currently, only 'MCMC' type is supported.}

\item{doPlot}{Logical indicating whether a plot should be printed on the 
currently active graphics device or whether only to return a list of plot- 
objects for further processing. Defaults to TRUE.}

\item{stat}{A character vector with the names of statistics to be plotted.
These should be names from the stats-list (see argument statFunctions).
Defaults to c("alpha", "theta", "sigma", "sigmae", "H2tMean", "H2tInf").}

\item{chain}{A vector of integers indicating the chains to be plotted.}

\item{doZoomIn}{(type MCMC only) A logical value indicating whether the 
produced plots should have a limitation on the x-axis according to an 
expression set in zoomInFilter (see below). Default value is FALSE.}

\item{zoomInFilter}{A character string which evaluates as logical value. If 
 doZoomIn is set to TRUE, this filter is applied to each point in each MCMC
 chain and the data-point is filtered out if it evaluates to FALSE. This 
 allows to zoomIn the x-axis of density plots but should be used with caution,
 since filtering out points from the MCMC-sample can affect the kernel densities.
 Unfortunately, filtering out values is currently the only way to affect the
 limits of individual facets in ggplot2. The default value is a complicated 
 expression involving the HPD from all MCMC chains (normally one chain from the
 prior and 2 chains from the posterior):
  zoomInFilter = paste0("stat %in% c('H2e','H2tMean','H2tInf','H2tMax') |",
The identifiers in this expression can be any
 column names found in a summary of a POUMM object.}

\item{palette}{A vector of colors (can be character strings) corresponding to the 
different chains (in their order 1 (prior), 2, 3). Defaults to c("#999999", 
"#0072B2", "#CC79A7", "#E69F00", "#D55E00", "#56B4E9", "#009E73", "#F0E442"),
which is a color-blind friendly.}

\item{prettyNames}{A logical indicating if greek letters and sub/superscripts 
should be used for the names of columns in the posterior density pairs-plot.}

\item{showUnivarDensityOnDiag}{A logical indicating if univariate density 
plots should be displaied on the main diagonal in the bivariate posterior plot.
Defaults to FALSE, in which case the column names are displayed on the diagonal.}

\item{...}{Not used; included for compatibility with the generic function plot.}
}
\value{
If doPlot==TRUE, the function returns nothing and produces output on 
the current graphics device as a side-effect. Otherwise, the function returns
a list of plot-objects: traceplot and densplot.
}
\description{
Plot a summary of a POUMM fit
}
\examples{
\dontrun{
library(POUMM)

set.seed(1)

N <- 1000

# create a random non-ultrametric tree of N tips
tree <- ape::rtree(N)  

# Simulate the evolution of a trait along the tree
z <- rVNodesGivenTreePOUMM(
  tree, g0 = 8, alpha = 1, theta = 4, sigma = 1.2, sigmae = .8)

fit <- POUMM(z[1:N], tree, spec = list(nSamplesMCMC = 4e5))

# Summarize the results from the fit in a table:
summary(fit)

# Create plots for some of the inferred parameters/statistics:
pl <- plot(fit, stat = c("alpha", "theta", "sigma", "sigmae", "H2tMean"), 
           doZoomIn = TRUE, 
           zoomInFilter = paste("!(stat \%in\% c('alpha', 'sigma', 'sigmae')) |",
                                "(value >= 0 & value <= 8)"),
           doPlot = FALSE)

pl$traceplot
pl$densplot
}

}

