% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{heatmap_ly}
\alias{heatmap_ly}
\title{A General Heatmap for Dynamically Assessing Power of the Sampling Plan Using a General Specification Limit.}
\usage{
heatmap_ly(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, test.point, dynamic)
}
\arguments{
\item{attr.name}{(optional) user-defined attribute name for sampling plan assessment}

\item{attr.unit}{(optional) user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{test.point}{(optional) actual process data points for testing whether the processes pass PPQ}

\item{dynamic}{logical; if \code{TRUE}, then convert the plain heatmap to dynamic graph using plotly.}
}
\value{
A Plain or Dynamic Heatmap for Sampling Plan Assessment.
}
\description{
The function for dynamically plotting (ggplot) the heatmap to evaluate the sampling plan based on a general lower and/or upper specification limits.
}
\examples{
\dontrun{
heatmap_ly(attr.name = "Thickness", attr.unit = "\%",Llim = -0.2, Ulim = 0.2, 
mu = seq(-0.2, 0.2, 0.001), sigma = seq(0,0.2, 0.001), 
test.point=data.frame(c(0.1,-0.05),c(0.15,0.05)), n=2, dynamic = T)
}
}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{pp} and \code{PPQ.occurve}.
}
\author{
Yalin Zhu
}
