% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.PPtreeclass}
\alias{print.PPtreeclass}
\title{Print PP.Tree.class result}
\usage{
\method{print}{PPtreeclass}(x, coef.print = FALSE, cutoff.print = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{x}{PPtreeclass object}

\item{coef.print}{print projection coefficients in each node ifTRUE}

\item{cutoff.print}{print cutoff values in each node if TRUE}

\item{verbose}{print if TRUE, no output if FALSE}

\item{...}{arguments to be passed to methods}
}
\description{
Print PP.Tree.class result
}
\details{
Print the projection pursuit classification tree result
}
\examples{
data(iris)
Tree.result <- PPTreeclass(Species~.,data = iris,"LDA")
Tree.result
print(Tree.result,coef.print=TRUE,cutoff.print=TRUE)

}
\references{
Lee, YD, Cook, D., Park JW, and Lee, EK(2013) 
PPtree: Projection Pursuit Classification Tree, 
Electronic Journal of Statistics, 7:1369-1386.
}
\keyword{tree}

