\name{plot_traj}

\alias{plot_traj}

\title{Visualization of Peeling Trajectories/Profiles}

\description{
  Function for plotting the cross-validated peeling trajectories/profiles of a \code{sbh} object.
  Applies to the pre-selected covariates specified by user and 
  all other statistical quantities of interest at each iteration of the peeling sequence 
  (inner loop of our PRSP or PRGSP algorithm). 
}

\usage{
  plot_traj(object,
            main = NULL, 
            toplot = object$cvfit$cv.used,
            col.cov, 
            lty.cov, 
            lwd.cov,
            col = 1, 
            lty = 1, 
            lwd = 0.5, 
            cex = 0.5, 
            add.caption = FALSE, 
            text.caption = NULL, 
            nr = NULL, 
            nc = NULL,
            device = NULL, 
            file = "Trajectory Plots", 
            path = getwd(), 
            horizontal = FALSE, 
            width = 8.5, 
            height = 11, ...)
}

\arguments{
  \item{object}{
    Object of class \code{sbh} as generated by the main function \code{\link[PRIMsrc]{sbh}}.
  }
  \item{main}{
    \code{Character} \code{vector}. Main Title. 
    Defaults to \code{NULL}.
  }
  \item{toplot}{
    \code{Numeric} \code{vector}. Which of the pre-selected covariates to plot (in reference to the original index of covariates).
    Defaults to covariates used for peeling.
  }
  \item{col.cov}{
    \code{Integer} \code{vector}. Line color for the covariate trajectory curve of each selected covariate. 
    Defaults to vector of colors of length the number of selected covariates. 
    The vector is reused cyclically if it is shorter than the number of selected covariates.
  }
  \item{lty.cov}{
    \code{Integer} \code{vector}. Line type for the covariate trajectory curve of each selected covariate. 
    Defaults to vector of 1's of length the number of selected covariates. 
    The vector is reused cyclically if it is shorter than the number of selected covariates.
  }
  \item{lwd.cov}{
    \code{Integer} \code{vector}. Line width for the covariate trajectory curve of each selected covariate. 
    Defaults to vector of 1's of length the number of selected covariates. 
    The vector is reused cyclically if it is shorter than the number of selected covariates.
  }
  \item{col}{
    \code{Integer} scalar. Line color for the trajectory curve of each statistical quantity of interest. 
    Defaults to 1.
  }
  \item{lty}{
    \code{Integer} scalar. Line type for the trajectory curve of each statistical quantity of interest. 
    Defaults to 1.
  }
  \item{lwd}{
    \code{Numeric} scalar. Line width for the trajectory curve of each statistical quantity of interest. 
    Defaults to 0.5.
  }
  \item{cex}{
    \code{Numeric} scalar. Symbol expansion used for titles, captions, and axis labels. 
    Defaults to 0.5.
  }
  \item{add.caption}{
    \code{Logical} scalar. Should the caption be plotted? 
    Defaults to \code{FALSE}.
  }
  \item{text.caption}{
    \code{Character} \code{vector} of caption content. 
    Defaults to \code{NULL}.
  }
  \item{nr}{
    \code{Integer} scalar of the number of rows in the plot. 
    If \code{NULL}, defaults to 3.
  }
  \item{nc}{
    \code{Integer} scalar of the number of columns in the plot. 
    If \code{NULL}, defaults to 3.
  }
  \item{device}{
    Graphic display device in \{\code{NULL}, "PS", "PDF"\}. 
    Defaults to \code{NULL} (standard output screen).
    Currently implemented graphic display devices are "PS" (Postscript) or "PDF" (Portable Document Format).
  }
  \item{file}{
    File name for output graphic. Defaults to "Trajectory Plots".
  }
  \item{path}{
    Absolute path (without final (back)slash separator). Defaults to working directory path.
  }
  \item{horizontal}{
    \code{Logical} scalar. Orientation of the printed image. Defaults to \code{FALSE}, that is potrait orientation.
  }
  \item{width}{
    \code{Numeric} scalar. Width of the graphics region in inches. 
    Defaults to 8.5.
  }
  \item{height}{
    \code{Numeric} scalar. Height of the graphics region in inches. 
    Defaults to 11.
  }
  \item{\dots}{
    Generic arguments passed to other plotting functions.
  }
}

\details{
  The plot limits the display of trajectories to those only covariates that are used for peeling.
  
  The plot includes box descriptive statistics (such as support), survival endpoint statistics
  (such as Maximum Event-Free Time (MEFT), Minimum Event-Free Probability (MEVP), LHR, LRT)
  and prediction performance (such as CER).
}

\value{
  Invisible. None. Displays the plot(s) on the specified \code{device}.
}

\author{
    \itemize{
        \item "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
        \item "Michael Choe, M.D." \email{mjc206@case.edu}
        \item "Michael LeBlanc, Ph.D." \email{mleblanc@fhcrc.org}
        \item "Alberto Santana, MBA." \email{ahs4@case.edu}
        \item "J. Sunil Rao, Ph.D." \email{Rao@biostat.med.miami.edu}
    }
    Maintainer: "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
}

\references{
    \itemize{
        \item Dazard J-E. and Rao J.S. (2018).
              "\emph{Variable Selection Strategies for High-Dimensional Survival Bump Hunting using Recursive Peeling Methods.}"
              (in prep).
        \item Rao J.S., Huilin Y. and Dazard J-E. (2018).
              "\emph{Disparity Subtyping: Bringing Precision Medicine Closer to Disparity Science.}"
              (in prep).
        \item Diaz-Pachon D.A., Saenz J.P., Dazard J-E. and Rao J.S. (2018).
              "\emph{Mode Hunting through Active Information.}"
              (in press).
        \item Diaz-Pachon D.A., Dazard J-E. and Rao J.S. (2017).
              "\emph{Unsupervised Bump Hunting Using Principal Components.}"           
              In: Ahmed SE, editor. Big and Complex Data Analysis: Methodologies and Applications. 
              Contributions to Statistics, vol. Edited Refereed Volume. 
              Springer International Publishing, Cham Switzerland, p. 325-345.
        \item Yi C. and Huang J. (2017).
              "\emph{Semismooth Newton Coordinate Descent Algorithm for Elastic-Net Penalized Huber Loss Regression and Quantile Regression}."
              J. Comp Graph. Statistics, 26(3):547-557.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2016).
              "\emph{Cross-validation and Peeling Strategies for Survival Bump Hunting using Recursive Peeling Methods.}"
              Statistical Analysis and Data Mining, 9(1):12-42.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2015).
              "\emph{R package PRIMsrc: Bump Hunting by Patient Rule Induction Method for Survival, Regression and Classification.}"
              In JSM Proceedings, Statistical Programmers and Analysts Section. Seattle, WA, USA.
              American Statistical Association IMS - JSM, p. 650-664.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2014).
              "\emph{Cross-Validation of Survival Bump Hunting by Recursive Peeling Methods.}"
              In JSM Proceedings, Survival Methods for Risk Estimation/Prediction Section. Boston, MA, USA.
              American Statistical Association IMS - JSM, p. 3366-3380.
        \item Dazard J-E. and J.S. Rao (2010).
              "\emph{Local Sparse Bump Hunting.}"
              J. Comp Graph. Statistics, 19(4):900-92.
    }
}

\section{Acknowledgments}{
    This work made use of the High Performance Computing Resource in the Core Facility for Advanced Research Computing at Case Western Reserve University. 
    This project was partially funded by the National Institutes of Health NIH - National Cancer Institute (R01-CA160593) to J-E. Dazard and J.S. Rao.
}

\note{
  End-user plotting function.
}

\keyword{Exploratory Survival/Risk Analysis}
\keyword{Survival/Risk Estimation & Prediction}
\keyword{Non-Parametric Method}
\keyword{Cross-Validation}
\keyword{Bump Hunting}
\keyword{Rule-Induction Method}
