% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_batch.R
\name{prism_batch}
\alias{prism_batch}
\title{PRISM stage 2 by batch}
\usage{
prism_batch(data, GTdata, var, n.training = 156, UseGoogle = T, alpha = 1,
  nPred.vec = 0:3, start.date = NULL, n.weeks = NULL, discount = 0.01,
  sepL1 = F)
}
\arguments{
\item{data}{time series of interest as xts, last element can be NA. (e.g., unemployment initial claim data in the same period as \code{GTdata}).}

\item{GTdata}{contemporaneous exogenous data as xts. (e.g., Google Trend data)}

\item{var}{generated regressors from stage 1.}

\item{n.training}{length of regression training period (by default = 156)}

\item{UseGoogle}{boolean variable indicating whether to use Google Trend data.}

\item{alpha}{penalty between lasso and ridge. alpha=1 represents lasso, alpha=0 represents ridge, alpha=NA represents no penalty.}

\item{nPred.vec}{the number of periods ahead for forecast. nPred.vec could be a vector of intergers. e.g. nPred.vec=0:3 gives results from nowcast to 3-week ahead forecast.}

\item{start.date}{the starting date for forecast. If NULL, the forecast start at the earliest possible date.}

\item{n.weeks}{the number of weeks in the batch. If NULL, the forecast end at the latest possible date.}

\item{discount}{exponential weighting: (1-discount)^lag (by default = 0.01)}

\item{sepL1}{if TRUE, use separate L1 regularization parameters for time series components and exogenous variables (Goolgle Trend data)}
}
\value{
A list of following named objects
\itemize{
\item \code{coef} coefficients for Intercept, z.lags, seasonal.lags and exogenous variables.
\item \code{pred} prediction results for \code{n.weeks} from \code{start.date}.
}
}
\description{
PRISM penalized linear regression function for a range of time (only used internally for back testing)
}
