% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\docType{methods}
\name{plotInfo}
\alias{plotInfo}
\alias{plotInfo,SingleGroupClass-method}
\title{Plot scale information}
\usage{
plotInfo(
  object,
  data,
  theta = seq(-4, 4, 0.1),
  t_score = FALSE,
  scale_label = c(1, 2, "Combined"),
  color = c("red", "blue", "black"),
  lty = c(3, 2, 1)
)

\S4method{plotInfo}{SingleGroupClass}(
  object,
  data,
  theta = seq(-4, 4, 0.1),
  t_score = FALSE,
  scale_label = c(1, 2, "Combined"),
  color = c("red", "blue", "black"),
  lty = c(3, 2, 1)
)
}
\arguments{
\item{object}{a \code{\linkS4class{SingleGroupClass}} object from \code{\link{runCalibration}}.}

\item{data}{a \code{\linkS4class{PROsetta_data}} object.}

\item{theta}{(optional) theta values to plot on the x-axis. (default = \code{seq(-4, 4, .1)})}

\item{t_score}{(optional) set to \code{TRUE} to plot T-scores on the x-axis instead of thetas. (default = \code{FALSE})}

\item{scale_label}{(optional) names of each scale. This must have three values. (default = \code{c(1, 2, "Combined")})}

\item{color}{(optional) line colors to plot. This must have three values. (default = \code{c("red", "blue", "black")})}

\item{lty}{(optional) line types to plot. This must have three values. (default = \code{c(3, 2, 1)})}
}
\description{
\code{\link{plotInfo}} is a plotting function to visualize scale-level information.
}
\examples{
\donttest{
o <- runCalibration(data_asq, technical = list(NCYCLES = 1000))
plotInfo(o, data_asq)
}

}
