% Generated by roxygen2 (4.0.1): do not edit by hand
\name{balance}
\alias{balance}
\title{Returns a summary of the balance for all bootstrap samples.}
\usage{
balance(psaboot, na.rm = TRUE, pool.fun = mean)
}
\arguments{
\item{psaboot}{results from \code{\link{PSAboot}}.}

\item{na.rm}{should NAs be removed. NAs generally occur when there is insufficient
sample for a particular covariate or an unused level.}

\item{pool.fun}{a function specifying how the effect sizes across all covariates
should be combined. Possible values include \code{mean} (default),
\code{\link{q25}}, \code{\link{q75}}, \code{median}, \code{max}, or
any function that takes a vector of numeric values.}
}
\value{
a list with three elements:
\describe{
	\item{unadjusted}{named numeric vector with unadjusted effect size before
	                  adjustment for each covaraite}
	\item{complete}{a matrix with adjusted effect size for each covariate (columns)
	                for each method (rows).}
	\item{pooled}{a matrix with mean adjusted effect size for all covariates for each
	              method (columns) and each bootstrap sample (rows).}
	\item{balances}{a list with an M x n covariates matrix for each method.}
}
}
\description{
This method provides some crude overall measures of balance.
}

