% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_wt.R
\name{psw.wt}
\alias{psw.wt}
\title{Propensity score weighting estimator}
\usage{
psw.wt(data, form.ps, weight, out.var, family = "gaussian", K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, \code{"OVERLAP"}, and \code{"TRAPEZOIDAL"}.}

\item{out.var}{outcome variable.}

\item{family}{outcome family, either \code{"gaussian"} or \code{"binomial"}. \code{family="gaussian"} by default.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight. The estimand is
closer to the average treatment effect (ATE) with larger value of \code{K}. \code{K=4} by default.}
}
\value{
A list of weighting method, fitted propensity score model, estimated propenstity scores, estimated propensity score weights,
weighted estimator and standard deviation estimator
\item{weight}{weighting method.}
\item{ps.model}{object returned by fitting the propensity score model using \code{glm} with \code{"binomial"} family.}
\item{ps.hat}{estimated propensity score.}
\item{W}{estimated propensity score weight.}
\item{est.wt}{weighted estimator for mean difference when \code{family = "gaussian"}.}
\item{std.wt}{standard deviation for \code{est.wt}.}
\item{est.risk.wt}{weighted estimator for risk difference when \code{family = "binomial"}.}
\item{std.risk.wt}{standard deviation for \code{est.risk.wt}.}
\item{est.rr.wt}{weighted estimator for relative risk when \code{family = "binomial"}.}
\item{std.rr.wt}{standard deviation for \code{est.rr.wt}.}
\item{est.or.wt}{weighted estimator for odds ratio when \code{family = "binomial"}.}
\item{std.or.wt}{standard deviation for \code{est.or.wt}.}
\item{est.lor.wt}{weighted estimator for log odds ratio when \code{family = "binomial"}.}
\item{std.lor.wt}{standard deviation for \code{est.lor.wt}.}
}
\description{
\code{psw.wt} is used to estimate the weighted treatment effect estimator (without double robustness).
}
\details{
\code{psw.wt} is used to estimate the weighted estimator, \eqn{\hat{\Delta}}, and make inference using the sandwich variance estimator
that takes into account the sampling variability in the estimated propensity score.
}
\examples{
# Load the test data set
data(test_data);
# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";
tmp <- psw.wt( data = test_data, weight = "ATE", form.ps = form.ps,
out.var = "Y", family = "gaussian" );

}
\seealso{
\link{psw}
}
