% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{LCSn}
\alias{LCSn}
\title{Find longest common substring from 'n' strings.}
\usage{
LCSn(strings, min_LCS_length = 0)
}
\arguments{
\item{strings}{A vector of strings in which to search for LCS}

\item{min_LCS_length}{Minimum length expected. Empty string is returned if the result is shorter}
}
\value{
longest common substring (or "" if shorter than \code{min_LCS_length})
}
\description{
Warning: greedy heuristic! This is not guaranteed to find the best solution (or any solution at all), since its done pairwise with the shortest input string as reference.
}
\examples{
LCSn(c("1_abcde...",
       "2_abcd...",
       "x_abc..."))  ## --> "_abc"
LCSn(c("16_IMU008_CISPLA_E5_R11", 
       "48_IMU008_CISPLA_P4_E7_R31",
       "60_IMU008_CISPLA_E7_R11"), 3) ## -->"_IMU008_CISPLA_"
LCSn(c("AAAAACBBBBB", 
       "AAAAADBBBBB",
       "AAAABBBBBEF",
       "AAABBBBBDGH")) ## -->  "BBBBB"
LCSn(c("AAAXXBBB",
       "BBBXXDDD",
       "XXAAADDD")) ## --> fails due to greedy approach; should be "XX"

}
