% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_IDsOverRT}
\alias{plot_IDsOverRT}
\title{Plot IDs over time for each Raw file.}
\usage{
plot_IDsOverRT(data, x_lim = range(data$RT), y_max = max(data$counts))
}
\arguments{
\item{data}{A data.frame with columns as described above}

\item{x_lim}{Limits of the x-axis (2-tuple)}

\item{y_max}{Maximum of the y-axis (single value)}
}
\value{
GGplot object
}
\description{
Uses plot_DataOverRT() internally.
}
\examples{
 data = data.frame(fc.raw.file = rep(paste('file', letters[1:3]), each=30),
                            RT = seq(20, 120, length.out = 30),
                        counts = c(rnorm(30, 400, 20), rnorm(30, 250, 15), rnorm(30, 50, 15)))
 plot_IDsOverRT(data)

}
