% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_power.R
\name{optimize_power}
\alias{optimize_power}
\title{Optimizes power to help in search for MDES or SS}
\usage{
optimize_power(
  d_m,
  search.type,
  MTP,
  target.power,
  power.definition,
  tol,
  start.low,
  start.high,
  MDES = NULL,
  J = NULL,
  K = 1,
  nbar = NULL,
  M = M,
  numZero = numZero,
  Tbar = Tbar,
  alpha,
  two.tailed,
  numCovar.1 = 0,
  numCovar.2 = 0,
  numCovar.3 = 0,
  R2.1 = 0,
  R2.2 = 0,
  R2.3 = 0,
  ICC.2 = 0,
  ICC.3 = 0,
  omega.2 = 0,
  omega.3 = 0,
  rho,
  B = NULL,
  parallel.WY.cores = 1,
  max.steps = 20,
  tnum = 1000,
  start.tnum = round(tnum/10),
  final.tnum = 4 * tnum,
  give.warnings = FALSE,
  grid.only = FALSE,
  grid.size = 5
)
}
\arguments{
\item{d_m}{string; a single context, which is a design and model
code. See pump_info() for list of choices.}

\item{search.type}{type of optimization search being conducted.
Options: K, J, nbar, mdes}

\item{MTP}{string, or vector of strings; multiple testing
procedure(s). See pump_info() for list of choices.}

\item{target.power}{target power for search algorithm.}

\item{power.definition}{see pump_info() for 
possible power definitions.}

\item{tol}{tolerance for target power, defaults to 0.01 (1%).
This parameter controls when the search is done: 
when estimated power (checked with `final.tnum` iterations) 
is within `tol`, the search stops.}

\item{start.low}{lower bound for optimization procedure}

\item{start.high}{upper bound for optimization procedure}

\item{MDES}{scalar or vector; the desired MDES values for each
outcome. Please provide a scalar, a vector of length M, or vector
of values for non-zero outcomes.}

\item{J}{scalar; the harmonic mean of number of level 2 units per
level 3 unit (schools per district). Note that this is not the
total number of level 2 units, but instead the number of level 2
units nested within each level 3 unit, so the total number of
level 2 units is J x K.}

\item{K}{scalar; the number of level 3 units (districts).}

\item{nbar}{scalar; the harmonic mean of the number of level 1
units per level 2 unit (students per school). Note that this is
not the total number of level 1 units, but instead the number of
level 1 units nested within each level 2 unit, so the total
number of level 1 units is nbar x J x K.}

\item{M}{scalar; the number of hypothesis tests (outcomes),
including zero outcomes.}

\item{numZero}{scalar; additional number of outcomes assumed to be
zero. Please provide NumZero + length(MDES) = M, if length(MDES)
is not 1.}

\item{Tbar}{scalar; the proportion of samples that are assigned to
the treatment.}

\item{alpha}{scalar; the family wise error rate (FWER).}

\item{two.tailed}{scalar; TRUE/FALSE for two-tailed or one-tailed
power calculation.}

\item{numCovar.1}{scalar; number of level 1 (individual)
covariates.}

\item{numCovar.2}{scalar; number of level 2 (school) covariates.}

\item{numCovar.3}{scalar; number of level 3 (district) covariates.}

\item{R2.1}{scalar, or vector of length M; percent of variation
explained by level 1 covariates for each outcome.}

\item{R2.2}{scalar, or vector of length M; percent of variation
explained by level 2 covariates for each outcome.}

\item{R2.3}{scalar, or vector of length M; percent of variation
explained by level 3 covariates for each outcome.}

\item{ICC.2}{scalar, or vector of length M; level 2 (school)
intraclass correlation.}

\item{ICC.3}{scalar, or vector length M; level 3 (district)
intraclass correlation.}

\item{omega.2}{scalar, or vector of length M; ratio of variance of
level 2 average impacts to variance of level 2 random intercepts.}

\item{omega.3}{scalar, or vector of length M; ratio of variance of
level 3 average impacts to variance of level 3 random intercepts.}

\item{rho}{scalar; assumed correlation between all pairs of test
statistics.}

\item{B}{scalar; the number of permutations for Westfall-Young
procedures.}

\item{parallel.WY.cores}{number of cores to use for parallel
processing of WY-SD.}

\item{max.steps}{how many steps allowed before terminating.}

\item{tnum}{scalar; the number of test statistics to draw.
Increasing tnum increases precision and computation time.}

\item{start.tnum}{number of samples to start search 
(this will increase with each step).}

\item{final.tnum}{number of samples for final draw.}

\item{give.warnings}{whether to return optimizer warnings}

\item{grid.only}{TRUE means generate a grid from start.low to start.high, 
but do not do iterative search. (Useful for mapping out the power 
curve rather than identifying a point of particular power.)}

\item{grid.size}{Number of points to check in initial search grid.
Grid will be spaced as a quadratic sequence 
(e.g., 0, 1, 4, 9, 16 for a 0-16 span).}
}
\value{
power
}
\description{
Optimizes power to help in search for MDES or SS
}
\keyword{internal}
