% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_functions.R
\name{pump_mdes_grid}
\alias{pump_mdes_grid}
\title{Run pump_mdes on varying values of parameters (grid function)}
\usage{
pump_mdes_grid(
  d_m,
  MTP = NULL,
  M = 1,
  target.power,
  power.definition,
  tol = 0.01,
  propZero = NULL,
  numZero = NULL,
  nbar,
  J = 1,
  K = 1,
  Tbar,
  alpha,
  numCovar.1 = NULL,
  numCovar.2 = NULL,
  numCovar.3 = NULL,
  R2.1 = NULL,
  R2.2 = NULL,
  R2.3 = NULL,
  ICC.2 = NULL,
  ICC.3 = NULL,
  omega.2 = NULL,
  omega.3 = NULL,
  rho = NULL,
  verbose = FALSE,
  drop.unique.columns = TRUE,
  ...
)
}
\arguments{
\item{d_m}{string; a single context, which is a design and model
code. See pump_info() for list of choices.}

\item{MTP}{string, or vector of strings; multiple testing
procedure(s). See pump_info() for list of choices.}

\item{M}{scalar; the number of hypothesis tests (outcomes),
including zero outcomes.}

\item{target.power}{target power for search algorithm.}

\item{power.definition}{see pump_info() for 
possible power definitions.}

\item{tol}{tolerance for target power, defaults to 0.01 (1%).
This parameter controls when the search is done: 
when estimated power (checked with `final.tnum` iterations) 
is within `tol`, the search stops.}

\item{propZero}{scalar; proportion of outcomes assumed to be zero
(alternative specification to numZero).  length(MDES) should be 1
or equal to (1-propZero)*M.}

\item{numZero}{scalar; additional number of outcomes assumed to be
zero. Please provide NumZero + length(MDES) = M, if length(MDES)
is not 1.}

\item{nbar}{scalar; the harmonic mean of the number of level 1
units per level 2 unit (students per school). Note that this is
not the total number of level 1 units, but instead the number of
level 1 units nested within each level 2 unit, so the total
number of level 1 units is nbar x J x K.}

\item{J}{scalar; the harmonic mean of number of level 2 units per
level 3 unit (schools per district). Note that this is not the
total number of level 2 units, but instead the number of level 2
units nested within each level 3 unit, so the total number of
level 2 units is J x K.}

\item{K}{scalar; the number of level 3 units (districts).}

\item{Tbar}{scalar; the proportion of samples that are assigned to
the treatment.}

\item{alpha}{scalar; the family wise error rate (FWER).}

\item{numCovar.1}{scalar; number of level 1 (individual)
covariates.}

\item{numCovar.2}{scalar; number of level 2 (school) covariates.}

\item{numCovar.3}{scalar; number of level 3 (district) covariates.}

\item{R2.1}{scalar, or vector of length M; percent of variation
explained by level 1 covariates for each outcome.}

\item{R2.2}{scalar, or vector of length M; percent of variation
explained by level 2 covariates for each outcome.}

\item{R2.3}{scalar, or vector of length M; percent of variation
explained by level 3 covariates for each outcome.}

\item{ICC.2}{scalar, or vector of length M; level 2 (school)
intraclass correlation.}

\item{ICC.3}{scalar, or vector length M; level 3 (district)
intraclass correlation.}

\item{omega.2}{scalar, or vector of length M; ratio of variance of
level 2 average impacts to variance of level 2 random intercepts.}

\item{omega.3}{scalar, or vector of length M; ratio of variance of
level 3 average impacts to variance of level 3 random intercepts.}

\item{rho}{scalar; assumed correlation between all pairs of test
statistics.}

\item{verbose}{TRUE/FALSE; Print out diagnostics of time, etc.}

\item{drop.unique.columns}{logical; drop all parameter columns that
did not vary across the grid.}

\item{...}{extra arguments passed to the underlying pump_power,
pump_sample, or pump_mdes functions.}
}
\value{
a pumpgridresult object containing MDES results.
}
\description{
See pump_power_grid() for more details.
}
\examples{
g <- pump_mdes_grid(d_m = "d3.2_m3ff2rc", MTP = "HO",
  target.power = c( 0.50, 0.80 ), power.definition = "D1indiv",
  tol = 0.05, M = 5, J = c( 3, 9 ), K = 7, nbar = 58,
  Tbar = 0.50, alpha = 0.15, numCovar.1 = 1, numCovar.2 = 1,
  R2.1 = 0.1, R2.2 = 0.7, ICC.2 = 0.05, ICC.3 = 0.9,
  rho = 0.4, tnum = 200)
}
\seealso{
Other grid functions: 
\code{\link{pump_power_grid}()},
\code{\link{pump_sample_grid}()}
}
\concept{grid functions}
