% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pump_power.R
\name{get_power_results}
\alias{get_power_results}
\title{Calculates different definitions of power (support function)}
\usage{
get_power_results(
  adj.pval.mat,
  unadj.pval.mat,
  ind.nonzero,
  alpha,
  drop.zero.outcomes = TRUE,
  adj = TRUE
)
}
\arguments{
\item{adj.pval.mat}{matrix; adjusted p-values, columns are outcomes}

\item{unadj.pval.mat}{matrix; unadjusted p-values, columns are
outcomes}

\item{ind.nonzero}{vector; which outcomes correspond to nonzero
effects.}

\item{alpha}{scalar; the family wise error rate (FWER).}

\item{drop.zero.outcomes}{logical; whether to report power results
for outcomes with MDES = 0.}

\item{adj}{logical; whether p-values are unadjusted or not.}
}
\value{
data frame; power results for individual, minimum, complete
  power.
}
\description{
This function takes in a matrix of adjusted p-values
  and unadjusted p-values and outputs different types of power.

  This function is mostly for internal use, but may be of interest
  to users who wish to calculate power on their own.
}
