% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilldeboeranalysis.R
\name{hilldeboeranalysis}
\alias{hilldeboeranalysis}
\title{Hill-Deboer Isotherm Non-Linear Analysis}
\usage{
hilldeboeranalysis(Ce, theta, Temp)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{theta}{is the fractional surface coverage}

\item{Temp}{the temperature of the adsorption experimentation in Kelvin}
}
\value{
the nonlinear regression, parameters for the Hill-Deboer isotherm,
and model error analysis
}
\description{
Hill-Deboer isotherm model describes as a case where there is
mobile adsorption as well as lateral interaction among molecules.The increased
or decreased affinity depends on the kind of force among the adsorption molecules.
If there is an attraction between adsorbed molecules, there is an increase in
affinity. On the other hand, decreased affinity happens when there is repulsion
among the adsorbed molecules.
}
\examples{
theta <- c(0.19729, 0.34870, 0.61475, 0.74324, 0.88544, 0.89007, 0.91067, 0.91067, 0.96114)
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Temp <- 298
hilldeboeranalysis(Ce,theta, Temp)
}
\references{
De Boer, J. H. (1953). The Dynamical Character of adsorption,
Oxford University Press, Oxford, England.

Foo, K. Y., and Hameed, B. H. (2009, September 13).
<doi:10.1016/j.cej.2009.09.013> Insights into the modeling of adsorption isotherm
systems. Chemical Engineering Journal.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
