% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_corrections.R
\name{plr_xbx_utc_model}
\alias{plr_xbx_utc_model}
\title{UTC Method for PLR Determination}
\usage{
plr_xbx_utc_model(
  df,
  var_list,
  by = "month",
  data_cutoff = 30,
  predict_data = NULL,
  ref_irrad = 900,
  irrad_range = 10
)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{var_list}{A list of the dataframe's standard variable names, obtained from
the output of \code{\link{plr_variable_check}}.}

\item{by}{String, either "day", "week", or "month". The time periods over which
to group data for regression.}

\item{data_cutoff}{The number of data points needed to keep a value in the 
final table. Regressions over less than this number and their data will be discarded.}

\item{predict_data}{optional; Dataframe; If you have preferred estimations of irradiance,
temperature, and wind speed, include them here to skip automatic generation. Format:
Irradiance, Temperature, Wind (optional).}

\item{ref_irrad}{The irradiance value at which to calculate the universal
temperature coefficient. Since irradiance is a much stronger influencer on power generation
than temperature, it is important to specify a small range of irradiance data 
from which to estimate the effect of temperature.}

\item{irrad_range}{The range of the subset used to calculate the universal
temperature coefficient. See above.}
}
\value{
Returns dataframe of results per passed time scale from XbX with 
universal temperature correction modeling
}
\description{
This function groups data by the specified time interval
and performs a linear regression using the formula: 
power_corr ~ irrad_var - 1.
Predicted values of irradiance, temperature, and wind speed (if applicable)
are added for reference. The function uses a universal temperature correction,
rather than the monthly regression correction done in other PLR determining methods.
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_xbx_utc_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL,
                                  ref_irrad = 900, irrad_range = 10)

}
