% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_quality.R
\name{spline_timestamp_sync}
\alias{spline_timestamp_sync}
\title{Spline columns to match timestamps.}
\usage{
spline_timestamp_sync(
  data,
  data_ts = "timestamp",
  merge_data,
  merge_ts = "timestamp"
)
}
\arguments{
\item{data}{A data frame with a correct timestamp column.}

\item{data_ts}{The column name for the \code{data}
timestamp. Defaults to 'timestamp'}

\item{merge_data}{A data frame that will be linearly
interpolated and merged with \code{data}.}

\item{merge_ts}{The column name for the
\code{merge_data} timestamp. Defaults to 'timestamp'.}
}
\value{
The resulting merged data frame.
}
\description{
Often timestamps of two data frames will be mismatched. To
produced matching timestamps, columns that may be splined
will be and then corresponding values at the 'correct'
timestamp are used.
}
\details{
Any value that can not be linearly interpolated such as a
string will remain the same.
}
\author{
Arash Khalilnejad
}
