% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_enhance.R
\name{raw_enhance}
\alias{raw_enhance}
\title{Process Raw Monitoring Data to Create raw_enhance Object}
\usage{
raw_enhance(df)
}
\arguments{
\item{df}{raw monitor data, as created by airsis_createRawDataframe or wrcc_createRawDataframe}
}
\value{
Dataframe with original raw data, plus new columns with raw naming scheme for downstream use.
}
\description{
Processes raw monitor data to add a uniform time axis and consistent data columns that can be handled by various
\code{raw~} functions. All original raw data is retained, and the following additional columns are added:

\itemize{
\item{dataSource}
\item{longitude}
\item{latitude}
\item{temperature}
\item{humidity}
\item{windSpeed}
\item{windDir}
\item{pressure}
\item{pm25}
}

The \code{datetime} column in the incoming dataframe may have missing hours. This time axis is expanded to a
uniform, hourly axes with missing data fields added for data columns.
}
\examples{
\dontrun{
# Fail gracefully if any resources are not available
try({

library(PWFSLSmoke)
df <- airsis_createRawDataframe(startdate=20160901, enddate=20161015, provider='USFS', unitID=1012)
df <- raw_enhance(df)
rawPlot_timeseries(df, tlim=c(20160908,20160917))

}, silent = FALSE)
}
}
\keyword{raw}
