% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBullseye.R
\name{addBullseye}
\alias{addBullseye}
\title{Add a Bullseyes to a Map or RgoogleMap Plot}
\usage{
addBullseye(longitude, latitude, map = NULL, cex = 2, lwd = 2)
}
\arguments{
\item{longitude}{vector of longitudes}

\item{latitude}{vector of latitudes}

\item{map}{optional RgoogleMaps map object}

\item{cex}{character expansion}

\item{lwd}{line width of individual circles}
}
\description{
Draws a bullseye with concentric circles of black and white.
}
\examples{
wa <- monitor_subset(Northwest_Megafires, stateCodes='WA', tlim=c(20150821,20150828))
monitor_map(wa, cex=4)
addBullseye(wa$meta$longitude, wa$meta$latitude)
}
\keyword{plotting}
