# Inputs and Expected Outputs
EXP_0_Taylor <- 1 / factorial(seq_len(11) - 1)
EXP_0_Pade32Numer <- c(1, 3 / 5, 3 / 20, 1 / 60)
EXP_0_Pade32Denom <- c(1, -2 / 5, 1 / 20)
EXP_0_Pade32_Estimate <- Pade(3, 2, EXP_0_Taylor)
EXP_0_Pade43Numer <- c(1, 4 / 7, 1 / 7, 2 / 105, 1 / 840)
EXP_0_Pade43Denom <- c(1, -3 / 7, 1 / 14, -1 / 210)
EXP_0_Pade43_Estimate <- Pade(4, 3, EXP_0_Taylor)

LOG1P_0_Taylor = c(0, 1, -1 / 2, 1 / 3, -1 / 4, 1 / 5, -1 / 6)
LOG1P_0_Pade33Numer = c(0, 1, 1, 11 / 60)
LOG1P_0_Pade33Denom = c(1, 1.5, 0.6, 0.05)
LOG1P_0_Pade33_Estimate <- Pade(3, 3, LOG1P_0_Taylor)

SIN_Taylor <- c(0, 1/factorial(1), 0, -1/factorial(3), 0, 1/factorial(5), 0,
                -1/factorial(7), 0, 1/factorial(9), 0, -1/factorial(11))
SIN_Pade56Numer <- c(0, 1, 0, -2363/18183, 0, 12671/4363920)
SIN_Pade56Denom <- c(1, 0, 445/12122, 0, 601/872784, 0, 121/16662240)
SIN_Pade56_Estimate <- Pade(5, 6, SIN_Taylor)

# Testing Accuracy
expect_equal(EXP_0_Pade32_Estimate[[1]], EXP_0_Pade32Numer)
expect_equal(EXP_0_Pade32_Estimate[[2]], EXP_0_Pade32Denom)
expect_equal(EXP_0_Pade43_Estimate[[1]], EXP_0_Pade43Numer)
expect_equal(EXP_0_Pade43_Estimate[[2]], EXP_0_Pade43Denom)
expect_equal(LOG1P_0_Pade33_Estimate[[1]], LOG1P_0_Pade33Numer)
expect_equal(LOG1P_0_Pade33_Estimate[[2]], LOG1P_0_Pade33Denom)
expect_equal(SIN_Pade56_Estimate[[1]], SIN_Pade56Numer)
expect_equal(SIN_Pade56_Estimate[[2]], SIN_Pade56Denom)

# Testing Errors
expect_error(Pade(4, 4, LOG1P_0_Taylor),
             "Not enough Taylor series coefficients provided.")
expect_error(Pade(7, 6, SIN_Taylor),
             "Not enough Taylor series coefficients provided.")
expect_error(Pade(4.2, 4, LOG1P_0_Taylor),
             "Polynomial orders need to be integers.")
expect_error(Pade(4, 3.4, LOG1P_0_Taylor),
             "Polynomial orders need to be integers.")
