% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_set_R.r
\name{get.matchedsets}
\alias{get.matchedsets}
\title{get.matchedsets}
\usage{
get.matchedsets(
  t,
  id,
  data,
  L,
  t.column,
  id.column,
  treatedvar,
  hasbeensorted = FALSE,
  match.on.missingness = TRUE,
  matching = TRUE,
  continuous = FALSE,
  continuous.treatment.info = NULL
)
}
\arguments{
\item{t}{integer vector specifying the times of treated units for which matched sets should be found. This vector should be the same length as the following \code{id} parameter -- the entries at corresponding indices in each vector should form the t,id pair of a specified treatment unit.}

\item{id}{integer vector specifying the unit ids of treated units for which matched sets should be found. note that both \code{t} and \code{id} can be of length 1}

\item{data}{data frame containing the data to be used for finding matched sets.}

\item{L}{An integer value indicating the length of treatment history to be matched}

\item{t.column}{Character string that identifies the name of the column in \code{data} that contains data about the time variable. Each specified entry in \code{t} should be somewhere in this column in the data. This data must be integer that increases by one.}

\item{id.column}{Character string that identifies the name of the column in \code{data} that contains data about the unit id variable. Each specified entry in \code{id} should be somewhere in this column in the data. This data must be integer.}

\item{treatedvar}{Character string that identifies the name of the column in \code{data} that contains data about the binary treatment variable.}

\item{hasbeensorted}{variable that only has internal usage for optimization purposes. There should be no need for a user to toggle this}

\item{match.on.missingness}{TRUE/FALSE indicating whether or not the user wants to "match on missingness." That is, should units with NAs in their treatment history windows be matched with control units that have NA's in corresponding places?}

\item{matching}{logical indicating whether or not the treatment history should be used for matching. This should almost always be set to TRUE, except for specific situations where the user is interested in particular diagnostic questions.}
}
\value{
\code{get.matchedsets} returns a "matched set" object, which primarily contains a named list of vectors. Each vector is a "matched set" containing the unit ids included in a matched set. The list names will indicate an i,t pair (formatted as "<i variable>.<t variable>") to which the vector/matched set corresponds.
}
\description{
\code{get.matchedsets} is used to identify matched sets for a given unit with a specified i, t.
}
\keyword{internal}
