% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelEstimateObject.R
\name{plot.PanelEstimate}
\alias{plot.PanelEstimate}
\title{Plot point estimates and standard errors from a PanelEstimate calculation.}
\usage{
\method{plot}{PanelEstimate}(
  x,
  ylab = "Estimated Effect of Treatment",
  xlab = "Time",
  main = "Estimated Effects of Treatment Over Time",
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{PanelEstimate} object}

\item{ylab}{default is "Estimated Effect of Treatment. This is the same argument as the standard argument for \code{plot}}

\item{xlab}{default is "Time". This is the same argument as the standard argument for \code{plot}}

\item{main}{default is "Estimated Effects of Treatment Over Time". This is the same argument as the standard argument for \code{plot}}

\item{ylim}{default is NULL. This is the same argument as the standard argument for \code{plot}}

\item{...}{Additional optional arguments to be passed to \code{plot}.}
}
\description{
The \code{plot.PanelEstimate} method takes an object returned by the \code{PanelEstimate} function and plots the calculated 
point estimates and standard errors over the specified \code{lead} time period. 
The only mandatory argument is an object of the \code{PanelEstimate} class.
}
\examples{
PM.results <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2", 
                         treatment = "dem", refinement.method = "mahalanobis", 
                         data = dem, match.missing = TRUE, 
                         covs.formula = ~ I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                         size.match = 5, qoi = "att",
                         outcome.var = "y", lead = 0:4, forbid.treatment.reversal = FALSE)
PE.results <- PanelEstimate(sets = PM.results, data = dem)
plot(PE.results)


}
