% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGPModel.R
\name{PGP_Model}
\alias{PGP_Model}
\title{PGP_Model (Collective Panjer & Generalized Pareto Model) Object}
\usage{
PGP_Model(
  FQ = NULL,
  t = NULL,
  alpha_ini = NULL,
  alpha_tail = NULL,
  truncation = NULL,
  dispersion = 1,
  Status = 0,
  Comment = "OK"
)
}
\arguments{
\item{FQ}{Numerical. Expected claim count of the collective model.}

\item{t}{Numeric. Threshold of the Pareto distribution. If \code{t} is \code{NULL} (default) then \code{t <- Attachment Point} is used}

\item{alpha_ini}{Numeric. Initial Pareto alpha (at \code{t}).}

\item{alpha_tail}{Numeric. Tail Pareto alpha.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}

\item{dispersion}{Numerical. Dispersion of the Panjer distribution (i.e. variance to mean ratio).}

\item{Status}{Numerical indicator if a function returns a PGP_Model object: 0 = success, 1 = some information has been ignored, 2 = no solution found}

\item{Comment}{Charakter. An optional comment.}
}
\description{
Constructor function for the PGP_Model object
}
\examples{
PGPM <- PGP_Model(2, t = 1000, alpha_ini = 1, alpha_tail = 2 , dispersion = 2)
PGPM

}
