% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vMF.R
\name{rvMF}
\alias{rvMF}
\title{Simulation from the von Mises-Fisher distribution}
\usage{
rvMF(size, theta)
}
\arguments{
\item{size}{is the number of simulations.}

\item{theta}{is the parameter as \code{eta*mu}.}
}
\value{
A matrix whose each row is a random draw from the distribution.
}
\description{
Random generation for the von Mises-Fisher distribution
of dimension \code{p} with location parameter \code{mu} and intensity parameter \code{eta}
(see Wood, 1994; Mardia, 2014).
}
\examples{
# Draw 10 vectors from vMF with parameters eta = 1 and mu = c(1,0)
rvMF(10,c(1,0))

# Draw 10 vectors from vMF with parameters eta = sqrt(14) and mu proportional to (2,1,3)
rvMF(10,c(2,1,3))

# Draw from the vMF distribution with mean direction proportional to c(1, -1)
# and concentration parameter 3
rvMF(10, 3 * c(1, -1) / sqrt(2))
}
