% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\name{buildPathwaySpace}
\alias{buildPathwaySpace}
\title{Constructor of PathwaySpace-class objects.}
\usage{
buildPathwaySpace(g, nrc = 500, mar = 0.075, verbose = TRUE)
}
\arguments{
\item{g}{An \code{igraph} object. It must include graph
layout information, with vertex coordinates assigned to \code{x} 
and \code{y} vertex attributes. It must also include vertex labels 
assigned to the \code{name} vertex attribute.}

\item{nrc}{A single positive integer indicating the number of rows and 
columns (in pixels) for a square image matrix. This argument will 
affect the resulting image size and resolution.}

\item{mar}{A single numeric value (in \code{[0,1]}) indicating the size of
the outer margins as a fraction of the image matrix.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}
}
\value{
A preprocessed \linkS4class{PathwaySpace} class object.
}
\description{
\code{buildPathwaySpace} is a constructor of
PathwaySpace-class objects.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'PathwaySpace')

# Create a new PathwaySpace object
pts <- buildPathwaySpace(gtoy1, nrc = 100)
# note: adjust 'nrc' to increase image resolution

}
\seealso{
\code{\link[igraph]{undirected_graph}}
}
\author{
Vinicius Chagas, Victor Apolonio, Mauro Castro,
and TCGA Network.
}
