% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{configurePython}
\alias{configurePython}
\title{Sets up a python environment to use for PLP (can be conda or venv)}
\usage{
configurePython(envname = "PLP", envtype = NULL, condaPythonVersion = "3.11")
}
\arguments{
\item{envname}{A string for the name of the virtual environment (default is 'PLP')}

\item{envtype}{An option for specifying the environment as'conda' or 'python'.  If NULL then the default is 'conda' for windows users and 'python' for non-windows users}

\item{condaPythonVersion}{String, Python version to use when creating a conda environment}
}
\value{
location of the created conda or virtual python environment
}
\description{
Sets up a python environment to use for PLP (can be conda or venv)
}
\details{
This function creates a python environment that can be used by PatientLevelPrediction
and installs all the required package dependancies.
}
\examples{
\dontshow{ # dontrun reason: don't modify environment in examples }
\dontrun{ 
 configurePython(envname="PLP", envtype="conda")
}
}
