% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plotGeneralizability}
\alias{plotGeneralizability}
\title{Plot the train/test generalizability diagnostic}
\usage{
plotGeneralizability(
  covariateSummary,
  saveLocation = NULL,
  fileName = "Generalizability.png"
)
}
\arguments{
\item{covariateSummary}{A prediction object as generated using the
\code{\link{runPlp}} function.}

\item{saveLocation}{Directory to save plot (if NULL plot is not saved)}

\item{fileName}{Name of the file to save to plot, for example
'plot.png'. See the function \code{ggsave} in the ggplot2 package for
supported file formats.}
}
\value{
A ggplot object. Use the \code{\link[ggplot2]{ggsave}} function to save to file in a different
format.
}
\description{
Plot the train/test generalizability diagnostic
}
\details{
Create a plot showing the train/test generalizability diagnostic
#'
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=1000)
population <- createStudyPopulation(plpData, outcomeId = 3)
data <- splitData(plpData, population = population)
strata <- data.frame(
 rowId = c(data$Train$labels$rowId, data$Test$labels$rowId),
 strataName = c(rep("Train", nrow(data$Train$labels)),
                rep("Test", nrow(data$Test$labels))))
covariateSummary <- covariateSummary(plpData$covariateData, 
                                     cohort = dplyr::select(population, "rowId"),
 strata = strata, labels = population)
plotGeneralizability(covariateSummary)
}
\dontshow{\}) # examplesIf}
}
