% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Formatting.R
\name{toSparseM}
\alias{toSparseM}
\title{Convert the plpData in COO format into a sparse R matrix}
\usage{
toSparseM(plpData, cohort = NULL, map = NULL)
}
\arguments{
\item{plpData}{An object of type \code{plpData} with covariate in coo format - the patient level prediction
data extracted from the CDM.}

\item{cohort}{If specified the plpData is restricted to the rowIds in the cohort (otherwise plpData$labels is used)}

\item{map}{A covariate map (telling us the column number for covariates)}
}
\value{
Returns a list, containing the data as a sparse matrix, the plpData covariateRef
and a data.frame named map that tells us what covariate corresponds to each column
This object is a list with the following components: \describe{
\item{data}{A sparse matrix with the rows corresponding to each person in the plpData and the columns corresponding to the covariates.}
\item{covariateRef}{The plpData covariateRef.}
\item{map}{A data.frame containing the data column ids and the corresponding covariateId from covariateRef.}
}
}
\description{
Converts the standard plpData to a sparse matrix
}
\details{
This function converts the covariates \code{Andromeda} table in COO format into a sparse matrix from
the package Matrix
}
\examples{
\donttest{ \dontshow{ # takes too long }
library(dplyr)
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=100)
# how many covariates are there before we convert to sparse matrix
plpData$covariateData$covariates \%>\% 
 dplyr::group_by(.data$covariateId) \%>\% 
 dplyr::summarise(n = n()) \%>\% 
 dplyr::collect() \%>\% nrow()
sparseData <- toSparseM(plpData, cohort=plpData$cohorts)
# how many covariates are there after we convert to sparse matrix'
sparseData$dataMatrix@Dim[2]
}
}
