% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PdPDB.R
\name{PdPDB}
\alias{PdPDB}
\title{Pattern Discovery in PDB Structures of Metalloproteins}
\usage{
PdPDB(path, metal, n)
}
\arguments{
\item{path}{A string containing the path to the PDB directory}

\item{metal}{A string containing the PDB chemical symbol of the target prosthetic centre; e.g. SF4 for [4Fe-4S] cluster, ZN for zinc. The PDB chemical symbol is case sensitive for macOS.}

\item{n}{A numerical value that contains the number or residue in +/- n position from the ligated amino acid or nucleotide; if n=1 PdPDB searches for x(L)x motif-like chains, if n=2 for xx(L)xx. (L)igand.}
}
\description{
Looks for amino acid and/or nucleotide patterns coordinated to a given prosthetic centre. It also accounts for small molecule ligands. Files have to be in the local file system and contain the '.pdb' extension.
}
\examples{
################ Defining path to PDBs
path_to_PDB="inst/extdata/PDB" # this is where pdb files are

################ Research Parameters
metal="mg"  	# searches for magnesium coordinated patterns;
n=1         	# searches for x(L)x motif like patterns, (L) coordinates to MG

################ Launch PdPDB
PdPDB(path_to_PDB,metal,n)
}
\author{
Luca Belmonte, Sheref S. Mansy
}
\references{
Belmonte L, Mansy SS PdPDB: An R tool for pattern discovery in PDB structures of metalloproteins, (in preparation)
}
\keyword{PDB,}
\keyword{centers,}
\keyword{cluster}
\keyword{coordination}
\keyword{metal,}
\keyword{metallo}
\keyword{patterns,}
\keyword{prosthetic}
\keyword{proteins,}
\keyword{sphere,}

