% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{lmm}
\alias{lmm}
\title{Learn a Mallows Model}
\usage{
lmm(data, sigma_0_ini = identity.permutation(dim(data)[2]),
  dist.name = "kendall", estimation = "approx", disk = FALSE)
}
\arguments{
\item{data}{the matrix with the permutations to estimate}

\item{sigma_0_ini}{optional the initial guess for the consensus permutation}

\item{dist.name}{optional the name of the distance used by the model. One of: kendall (default), cayley, hamming, ulam}

\item{estimation}{optional select the approximated or the exact. One of: approx, exact}

\item{disk}{optional can only be true if estimating a MM under the Ulam distance.
Insted of generating the whole set of SYT and count of permutations per distance, it loads the info from a file in the disk}
}
\value{
A list with the parameters of the estimated distribution: the
mode and the dispersion parameter
}
\description{
Learn the parameter of the distribution of a sample of n permutations 
comming from a Mallows Model (MM).
}
\examples{
data <- matrix(c(1,2,3,4, 1,4,3,2, 1,2,4,3), nrow = 3, ncol = 4, byrow = TRUE)
lmm(data, dist.name="kendall", estimation="approx")
lmm(data, dist.name="cayley", estimation="approx")
lmm(data, dist.name="cayley", estimation="exact")
lmm(data, dist.name="hamming", estimation="exact")
lmm(data, dist.name="ulam", estimation="approx")
}
\references{
"Ekhine Irurozki, Borja Calvo, Jose A. Lozano (2016). PerMallows: An R Package for Mallows and Generalized Mallows Models. Journal of Statistical Software, 71(12), 1-30. doi:10.18637/jss.v071.i12"
}

