% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reoptimize.R
\name{Reoptimize}
\alias{Reoptimize}
\title{Gives the Optimal Dose for enrolling next patient cohort.}
\usage{
Reoptimize(Y, I, YE, YT, Doses, Dose, Hypermeans, Hypervars, B)
}
\arguments{
\item{Y}{Vector containing observed patient survival or follow up times.}

\item{I}{Vector indicating whether each patient experienced an exent.}

\item{YE}{Vector containing observed efficacy indicators.}

\item{YT}{Vector containing observed toxicity indicators.}

\item{Doses}{Vector containing standardized doses of patients in trial.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{Hypermeans}{Vector containing prior hypermeans of length 6 for Eff-Tox parameters.}

\item{Hypervars}{Vector containing prior hypervariances of length 6 for Eff-Tox parameters.}

\item{B}{Number of iterations to perform in the MCMC.}
}
\description{
This function returns the optimal dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
}
\examples{
##Doses, YE,YT
Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
Y=rexp(length(YE))
I=rbinom(length(YE),1,.9)
##Vector of Numerical Doses
Dose = c(1,2,3,3.5,5)
Dose=(Dose-mean(Dose))/sd(Dose)
Doses=Dose[Doses]
##Hypermeans for Eff-Tox
Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
Hypervars=Hypervars^2
###Number of iterations
B=20000
Reoptimize(Y,I,YE,YT, Doses, Dose, Hypermeans,  Hypervars,B)
}
\references{
[1] Chapple and Thall (2018). A Hybrid Phase 12/3 Clinical Trial Design Allowing Dose-Re-Optimization in Phase 3 Biometrics. Under Review.
}
