% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PH_functions.R
\name{PH_functions}
\alias{PH_functions}
\alias{dPH}
\alias{qPH}
\alias{pPH}
\alias{rPH}
\alias{rFullPH}
\title{The Univariate Continuous Phase-Type Distribution}
\usage{
dPH(x, obj)

qPH(p, obj)

pPH(q, obj)

rPH(n, obj)

rFullPH(obj)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{obj}{an object of class \code{cont_phase_type}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be
the number required.}
}
\value{
\code{dPH} gives the density, \code{pPH} gives the
distribution function, \code{qPH} gives the quantile function,
and \code{rPH} generates random deviates. \code{rFullPH} returns
the full path of a random draw from the distribution.

The length of the result is determined by \code{n} for \code{rPH},
and is the maximum of the lengths of the numerical arguments for the other
functions.

The numerical arguments other than \code{n} are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation
for the univariate continuous phase-type distribution.
}
\section{Functions}{
\itemize{
\item \code{dPH}: Density function for the univariate continuous phase-type distribution.

\item \code{qPH}: Quantile function for the univariate continuous phase-type distribution.

\item \code{pPH}: Distribution function for the univariate continuous phase-type distribution.

\item \code{rPH}: Random number generator for the univariate continuous phase-type distribution.

\item \code{rFullPH}: Simulation of the full path for the univariate continuous phase-type distribution.
}}

\examples{

cont_phase_type <- matrix(c(-3, 0, 1,
                            2, -3, 1,
                            1, 1, -2), ncol = 3)
Y <- PH(cont_phase_type)

dPH(3:4, Y)
pPH(1.45, Y)
qPH(0.5, Y)
set.seed(0)
rPH(6, Y)
rFullPH(Y)


}
\seealso{
\link[stats]{Distributions} for other standard distributions.
}
