% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmBadStrings_1.R
\name{rmBadStrings_1}
\alias{rmBadStrings_1}
\title{Remove Mismatched DNA Sequences}
\usage{
rmBadStrings_1(
  DNAStringSet,
  specimen_dataframe,
  rmOutliers = FALSE,
  max_Z_score = 3
)
}
\arguments{
\item{DNAStringSet}{A DNA string set object.}

\item{specimen_dataframe}{A dataframe with speciment data created using querySpecData().}

\item{rmOutliers}{A logical value to state whether to remove DNA distance outlier strings}

\item{max_Z_score}{A numerical value to change the max Z score when removing outliers.}
}
\value{
A list with two elements: the DNA string set with the mismatched sequences removed (1st element) and the specimen dataframe with data for the mismatched sequences removed (2nd element).
}
\description{
Identify and remove bad DNA sequences within a string set. Prioritise removal by the smallest base width first.
}
\examples{
# remove problem strings from a DNA string set
specdata <- querySpecData("Panthera leo")

specdata <- subset(specdata, markercode == "COI-5P")

DNABin_Leo <- genDNABin(specdata)

DNAStringset_Leo <- genDNAStringSet(DNABin_Leo)

DNAStringSet_Leo_manipulated <- ManipStringSet(DNAStringset_Leo)

StringsAndSpecdataframe <- rmBadStrings_1(

 DNAStringSet = DNAStringSet_Leo_manipulated,
 specimen_dataframe = specdata

)

DNAStringSet_NEW <- StringsAndSpecdataframe[[1]]

tail(DNAStringSet_NEW)

specimen_dataframe_NEW <- StringsAndSpecdataframe[[2]]

tail(specimen_dataframe_NEW$processid)
}
